@extends('backEnd.layouts.master') 
@section('title','SMS Gateway')
@section('css')
<style>
  .increment_btn,
  .remove_btn {
    margin-top: -17px;
    margin-bottom: 10px;
  }
</style>
<link href="{{asset('public/backEnd')}}/assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
<link href="{{asset('public/backEnd')}}/assets/libs/summernote/summernote-lite.min.css" rel="stylesheet" type="text/css" />
@endsection @section('content')
<div class="container-fluid">
<!-- start page title -->
<div class="row">
  <div class="col-12">
    <div class="page-title-box d-flex align-items-center">
      <img src="{{ asset('public/frontEnd/images/bulksms.png') }}" alt="Bkash Logo" style="height: 35px; margin-right: 10px;">
      <h4 class="page-title">Bulksmsbd.net</h4>
    </div>
  </div>
</div>
<!-- end page title -->

<div class="row justify-content-center">
  <div class="col-lg-12">
    <div class="card" style="border: 1px solid #ff4d4d; border-radius: 6px;">
      <div class="card-body">
        <form action="{{route('smsgeteway.update')}}" method="POST" class="row" data-parsley-validate="" enctype="multipart/form-data">
          @csrf
          <input type="hidden" name="id" value="{{$sms->id}}">
          
          <div class="col-sm-4">
            <div class="form-group mb-3">
              <label for="api_key" class="form-label">API Key *</label>
              <input type="text" class="form-control @error('api_key') is-invalid @enderror" name="api_key" value="{{ $sms->api_key }}" id="api_key" required="" />
              @error('api_key')
              <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
              </span>
              @enderror
            </div>
          </div>
          <!-- col-end -->
          
          <div class="col-sm-4">
            <div class="form-group mb-3">
              <label for="serderid" class="form-label">Senderid *</label>
              <input type="text" class="form-control @error('serderid') is-invalid @enderror" name="serderid" value="{{ $sms->serderid }}" id="serderid" required="" />
              @error('serderid')
              <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
              </span>
              @enderror
            </div>
          </div>
          
          <!-- put this after Senderid input -->
<div class="col-sm-4">
  <div class="form-group mb-3">
    <label for="admin_phone_list" class="form-label">Admin Phone List (comma separated)</label>
    <input type="text" class="form-control @error('admin_phone_list') is-invalid @enderror" name="admin_phone_list" id="admin_phone_list"
           value="{{ old('admin_phone_list', env('ADMIN_PHONE_LIST', $sms->admin_phone ?? '')) }}" placeholder="01711111111,01722222222" />
    <small class="form-text text-muted">Multiple numbers comma separated. e.g. 01711111111,01722222222</small>
    @error('admin_phone_list')
    <span class="invalid-feedback" role="alert"><strong>{{ $message }}</strong></span>
    @enderror
  </div>
</div>

          <!-- col-end -->
          

          <div class="col-sm-3 mb-3">
            <div class="form-group">
              <label for="status" class="d-block">Status</label>
              <label class="switch">
                <input type="checkbox" value="1" @if($sms->status==1)checked @endif name="status" />
                <span class="slider round"></span>
              </label>
              @error('status')
              <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
              </span>
              @enderror
            </div>
          </div>
          <!-- col end -->

          <div class="col-sm-3 mb-3">
            <div class="form-group">
              <label for="order" class="d-block">Order confirm</label>
              <label class="switch">
                <input type="checkbox" value="1" @if($sms->order==1)checked @endif name="order" />
                <span class="slider round"></span>
              </label>
              @error('order')
              <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
              </span>
              @enderror
            </div>
          </div>
          <!-- col end -->

          <div class="col-sm-3 mb-3">
            <div class="form-group">
              <label for="forget_pass" class="d-block">Forgot password</label>
              <label class="switch">
                <input type="checkbox" value="1" @if($sms->forget_pass==1)checked @endif name="forget_pass" />
                <span class="slider round"></span>
              </label>
              @error('forget_pass')
              <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
              </span>
              @enderror
            </div>
          </div>
          <!-- col end -->

          <div class="col-sm-3 mb-3">
            <div class="form-group">
              <label for="password_g" class="d-block">Password Generator</label>
              <label class="switch">
                <input type="checkbox" value="1" @if($sms->password_g==1)checked @endif name="password_g" />
                <span class="slider round"></span>
              </label>
              @error('password_g')
              <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
              </span>
              @enderror
            </div>
          </div>
          <!-- col end -->

          <div>
            <input type="submit" class="btn btn-success" value="Submit" />
          </div>
        </form>
      </div>
      <!-- end card-body-->
    </div>
    <!-- end card-->
  </div>
  <!-- end col-->
</div>
<!-------------new-start------------>
<style>
.red-border-card {
  border: 1px solid #ff4d4d !important;
  border-radius: 6px;
}

</style>
  
  
</div>
@endsection @section('script')
<script src="{{asset('public/backEnd/')}}/assets/libs/parsleyjs/parsley.min.js"></script>
<script src="{{asset('public/backEnd/')}}/assets/js/pages/form-validation.init.js"></script>
<script src="{{asset('public/backEnd/')}}/assets/libs/select2/js/select2.min.js"></script>
<script src="{{asset('public/backEnd/')}}/assets/js/pages/form-advanced.init.js"></script>
<!-- Plugins js -->
<script src="{{asset('public/backEnd/')}}/assets/libs//summernote/summernote-lite.min.js"></script>
<script>
  $(".summernote").summernote({
    placeholder: "Enter Your Text Here",
  });
</script>
<script type="text/javascript">
  $(document).ready(function () {
    $(".btn-increment").click(function () {
      var html = $(".clone").html();
      $(".increment").after(html);
    });
    $("body").on("click", ".btn-danger", function () {
      $(this).parents(".control-group").remove();
    });
  });
</script>
<script type="text/javascript">
  $(document).ready(function () {
    $(".increment_btn").click(function () {
      var html = $(".clone_price").html();
      $(".increment_price").after(html);
    });
    $("body").on("click", ".remove_btn", function () {
      $(this).parents(".increment_control").remove();
    });

    $(".select2").select2();
  });
</script>
@endsection