<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncompleteOrder extends Model
{
    use HasFactory;

    /**
     * যদি তোমার টেবিলের নাম 'incomplete_orders' হয়
     * তাহলে নিচের লাইন দরকার নেই, কারণ Laravel নিজেই ধরে ফেলবে।
     * কিন্তু ক্লিয়ার করার জন্য রেখে দিতে চাইলে আনকমেন্ট করে ব্যবহার করতে পারো।
     */
    // protected $table = 'incomplete_orders';

    /**
     * কোন কোন ফিল্ড mass assignment দিয়ে fill করা যাবে
     */
    protected $fillable = [
        'name',
        'phone',
        'address',
        'items',
        'product_image',
        'product_link',
        'total_amount',
    ];

    /**
     * items কলামকে স্বয়ংক্রিয়ভাবে array <-> json convert করার জন্য
     */
    protected $casts = [
        'items' => 'array',
        'total_amount' => 'float',
    ];

    /**
     * যদি তোমার টেবিলে created_at / updated_at না থাকে,
     * তাহলে timestamps = false করে দাও।
     * নাহলে এটাকে বাদ দিতে পারো।
     */
    // public $timestamps = false;
}
